#!/bin/sh

MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_OK=0
MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_ERROR=1
MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_CODE=${MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_ERROR}

MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_ROLLING=0
MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_MSG=""

master_page_new_esxi_nat_dhcp_or_static() {
	debug_print $0 $LINENO "in function \"master_page_new_esxi_nat_dhcp_or_static\""
    
	tp_dhcp_or_static \
		"${MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_TITLE}" \
		"${MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_TEXT}" \
		"${MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_LABEL_OK}" \
		"${MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_LABEL_CANCEL}"

	debug_print "${0}" "${LINENO}" "TP_DHCP_OR_STATIC_RESULT_CODE: ${TP_DHCP_OR_STATIC_RESULT_CODE}"
    case "${TP_DHCP_OR_STATIC_RESULT_CODE}" in
    
        "${TP_DHCP_OR_STATIC_RESULT_ERROR}")
            MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_ERROR
            MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_MSG=""
            MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_ROLLING=0
            return
            ;;
        
        "${TP_DHCP_OR_STATIC_RESULT_CANCEL}")
            MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_OK
            MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_MSG=""
            MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_ROLLING=-2
            return
            ;;
            
        "${TP_DHCP_OR_STATIC_RESULT_OK}" )
            ;;
        
        *)
            MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_ERROR
            MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_MSG="${ERROR_UNKNOWN}"
            MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_ROLLING=0
            return
            ;;
    esac
   
	case "${TP_DHCP_OR_STATIC_RESULT_SELECT}" in
	
		# user choose "use static ip"
		"${TP_DHCP_OR_STATIC_RESULT_STATIC}")
			
			MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_OK
			MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_ROLLING=1
			MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_MSG=""
			;;
		
		# user choose "use DHCP"
		"${TP_DHCP_OR_STATIC_RESULT_DHCP}")
			local use_dhcp=1	
			# apply and error handling
			utility_apply_cluster_nat_network_conf "${new_esxi_sc_id}" "${use_dhcp}" "" "" "" ""
			if [ "${?}" -ne 0 ]; then
				MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_ERROR
				MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_ROLLING=0
				MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_MSG="${UTILITY_APPLY_CLUSTER_NAT_NETWORK_CONF_RESULT_MSG}"
				return
			fi
			
			# save to database
			utility_save_cluster_nat_network_conf \
				"${new_esxi_sc_id}" \
				"${use_dhcp}" \
				"${UTILITY_APPLY_CLUSTER_NAT_NETWORK_CONF_RESULT_IP}" \
				"${UTILITY_APPLY_CLUSTER_NAT_NETWORK_CONF_RESULT_NETMASK}" \
				"${UTILITY_APPLY_CLUSTER_NAT_NETWORK_CONF_RESULT_GATEWAY}" \
				"${UTILITY_APPLY_CLUSTER_NAT_NETWORK_CONF_RESULT_DNS}"
			if [ "${?}" -ne 0 ]; then
				MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_ERROR
				MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_ROLLING=0
				MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_MSG="${UTILITY_SAVE_CLUSTER_NAT_NETWORK_CONF_RESULT_MSG}"
				return
            fi
			
			MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_OK
			MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_ROLLING=2
			MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_MSG=""
			;;
		
		*)
			MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_ERROR
			MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_MSG="${ERROR_UNKNOWN}"
			MASTER_PAGE_NEW_ESXI_NAT_DHCP_OR_STATIC_RESULT_ROLLING=0
			;;
	esac
}